/*!
 * @file        app.h
 *
 * @brief       Header for app.c module
 *
 * @version     V1.0.0
 *
 * @date        2022-02-25
 *
 * @attention
 *
 *  Copyright (C) 2021-2022 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be usefull and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

#ifndef _APP_H
#define _APP_H

#include "main.h"

/**
 * @brief Touch event
 */
typedef struct
{
    uint8_t touchDownStatus;
    uint8_t touchUpStatus;
} TOUCH_EVENT_T;

/**
 * @brief Touch button type
 */
typedef enum
{
    TOUCH_LED,
    TOUCH_REFRESH,
    TOUCH_HELP,
} TOUCH_BUTTON_T;

/** extern variables*/
extern TOUCH_EVENT_T touchLED;
extern TOUCH_EVENT_T touchRefresh;
extern TOUCH_EVENT_T touchHelp;

/** function declaration*/
void Touch_DisplayInitUI(void);
void Touch_EventHandle(void);

#endif
